	.include	'eq.s'
	.include	'externs.s'

	.text

congloop::
	bsr		conginfo

	move.l	#congobjs,FIRSTOBJ_ADR		;address of first object header
	move.l	#CONGRATS_OBJS,TOTOBJS_ADR	;total objects in list
	bsr		do_build					;build packed object list

	bsr		input
	rts

conginfo::
	bsr		draw_score
	rts


go_cong::
	jsr		clearscr

	bsr		ld_decmp				;load decompression GPU code
	move.l	#q65,a3				;starting address of dq_table
	bsr		load_dq

	move.l	#56,Out_Width
	move.l	#WID448,Out_E_Width
	move.l	#congpic,In_Adr		;address of compressed picture data
	move.l	#congscrn,Out_Adr		;where to put the decompressed data
	bsr		decomp

	move.l	#24,Out_Width
	move.l	#WID192,Out_E_Width
	move.l	#congtx0,In_Adr		;address of compressed picture data
	move.l	#cngline0,Out_Adr		;where to put the decompressed data
	bsr		decomp

	move.l	#20,Out_Width
	move.l	#WID160,Out_E_Width
	move.l	#congtx1,In_Adr		;address of compressed picture data
	move.l	#cngline1,Out_Adr		;where to put the decompressed data
	bsr		decomp

	move.l	#28,Out_Width
	move.l	#WID224,Out_E_Width
	move.l	#congtx2,In_Adr		;address of compressed picture data
	move.l	#cngline2,Out_Adr		;where to put the decompressed data
	bsr		decomp

	move.l	#10,Out_Width
	move.l	#WID80,Out_E_Width
	move.l	#congtx3,In_Adr		;address of compressed picture data
	move.l	#cngline6,Out_Adr		;where to put the decompressed data
	bsr		decomp

	move.l	#40,Out_Width
	move.l	#WID320,Out_E_Width
	move.l	#congtx4,In_Adr		;address of compressed picture data
	move.l	#cngline7,Out_Adr		;where to put the decompressed data
	bsr		decomp

	move.l	#32,Out_Width
	move.l	#WID256,Out_E_Width
	move.l	#congtx5,In_Adr		;address of compressed picture data
	move.l	#cngline8,Out_Adr		;where to put the decompressed data
	bsr		decomp

	bsr		ld_uncmp

	move.l	#msk_cong,a0			;address of table of mask info
	move.w	#6,d0				;number of masks
	bsr		do_mask

	move.w	#SCRN_TOP+24,congln0+O_YPOS
	move.w	#SCRN_TOP+72,congln1+O_YPOS
	move.w	#SCRN_TOP+120,congln2+O_YPOS
	move.w	#SCRN_TOP+168,congln3+O_YPOS
	move.w	#SCRN_TOP+216,congln4+O_YPOS
	move.w	#SCRN_TOP+264,congln5+O_YPOS
	move.w	#SCRN_TOP+312,congln6+O_YPOS
	move.w	#SCRN_TOP+360,congln7+O_YPOS
	move.w	#SCRN_TOP+408,congln8+O_YPOS

	move.w	#36+45,congln0+O_XPOS
	move.w	#36+56,congln1+O_XPOS
	move.w	#36+26,congln2+O_XPOS
	move.w	#36+52,congln3+O_XPOS
	move.w	#36+40,congln4+O_XPOS
	move.w	#36+28,congln5+O_XPOS
	move.w	#36+90,congln6+O_XPOS
	move.w	#36+0,congln7+O_XPOS
	move.w	#36+16,congln8+O_XPOS

	move.b	#CONGRATS_MODE,gamemode
	bsr		conv_score			;update score numbers
	bsr		erase_info
	bsr		ld_build				;load object list builder GPU code
	rts

;tables for loading congrats text masks
;A1_BASE				destination address
;width for blitter
;B_COUNT				height, width
;A1_STEP and A2_STEP	1, negative width
;UNCOMP_START			address of compressed mask
;size of mask / 8
msk_cong:
	dc.l		cngline0,		WID192,	$001E00C0,	$0001FF40,	cngtx0m,	(192*30/8)
	dc.l		cngline1,		WID160,	$001E00A0,	$0001FF60,	cngtx1m,	(160*30/8)
	dc.l		cngline2,		WID224,	$001E00E0,	$0001FF20,	cngtx2m,	(224*30/8)
	dc.l		cngline6,		WID80,	$000C0050,	$0001FFB0,	cngtx3m,	(80*12/8)
	dc.l		cngline7,		WID320,	$000F0140,	$0001FEC0,	cngtx4m,	(320*15/8)
	dc.l		cngline8,		WID256,	$000F0100,	$0001FF00,	cngtx5m,	(256*15/8)


congolst::
;congscr::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			;xpos	
	dc.w		SCRN_TOP		;ypos
	dc.w		288			; o_height
	dc.w		112			; o_dwidth
	dc.w		112			; o_iwidth
	dc.l		congscrn		; o_data
	dc.b		0			; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;congln0::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		15			; o_height
	dc.w		48			; o_dwidth
	dc.w		48			; o_iwidth
	dc.l		cngline0		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;congln1::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		15			; o_height
	dc.w		40			; o_dwidth
	dc.w		40			; o_iwidth
	dc.l		cngline1		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;congln2::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		15			; o_height
	dc.w		56			; o_dwidth
	dc.w		56			; o_iwidth
	dc.l		cngline2		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;congln3::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		15			; o_height
	dc.w		40			; o_dwidth
	dc.w		40			; o_iwidth
	dc.l		cngline3		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;congln4::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		15			; o_height
	dc.w		48			; o_dwidth
	dc.w		48			; o_iwidth
	dc.l		cngline4		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;congln5::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		15			; o_height
	dc.w		56			; o_dwidth
	dc.w		56			; o_iwidth
	dc.l		cngline5		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;congln6::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		12			; o_height
	dc.w		20			; o_dwidth
	dc.w		20			; o_iwidth
	dc.l		cngline6		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;congln7::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		15			; o_height
	dc.w		80			; o_dwidth
	dc.w		80			; o_iwidth
	dc.l		cngline7		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;congln8::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		4			; o_depth
	dc.w		0			;xpos	
	dc.w		0			;ypos
	dc.w		15			; o_height
	dc.w		64			; o_dwidth
	dc.w		64			; o_iwidth
	dc.l		cngline8		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;congscor::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		3			; o_depth
	dc.w		SCORE_XPOS	;xpos	
	dc.w		SCORE_YPOS	;ypos
	dc.w		12			; o_height
	dc.w		10			; o_dwidth
	dc.w		10			; o_iwidth
	dc.l		scorebar		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00000000		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------

